@echo off
setlocal enabledelayedexpansion

REM Prfe Admin-Rechte
net session >nul 2>&1
if %errorlevel% neq 0 (
    echo Bitte dieses Script als Administrator ausfuehren!
    pause
    exit /b
)

echo ==========================================================
echo Warte auf Netzwerkadapter mit IPv4 Adresse im Bereich 192.168.x.x
echo ==========================================================
echo.

:WARTEN
REM IP-Adresse suchen
set "IP="

for /f "tokens=2 delims=:" %%A in ('ipconfig ^| findstr /R /C:"IPv4.*192\.168\."') do (
    set "IP=%%A"
    set "IP=!IP: =!"
    goto IP_GEFUNDEN
)

echo Kein Netzwerkadapter mit 192.168.x.x gefunden. Warte 30 Sekunde... Bitte das Fenster nicht schliessen.
timeout /t 30 /nobreak >nul
goto WARTEN

:IP_GEFUNDEN
echo Gefundene IP-Adresse: %IP%

REM Drittes Oktett extrahieren
for /f "tokens=3 delims=." %%B in ("%IP%") do set "THIRD=%%B"
echo Drittes Oktett der IP-Adresse: %THIRD%

REM Gateway IP bauen
set "GATEWAY=192.168.%THIRD%.254"
echo Geplante Gateway-IP: %GATEWAY%

REM Alte Route lschen (falls vorhanden)
echo Route 10.0.0.0 lschen (falls vorhanden)...
route delete 10.0.0.0 >nul 2>&1

REM Neue Route setzen
echo Route hinzufgen...
route add 10.0.0.0 mask 255.0.0.0 %GATEWAY% -p

if %ERRORLEVEL% EQU 0 (
    echo Route erfolgreich gesetzt!
) else (
    echo Fehler beim Setzen der Route!
)

echo.
echo ==========================================================
echo Script wird in 5 Sekunden automatisch beendet...
echo ==========================================================
timeout /t 5 /nobreak >nul
endlocal
exit /b
